<?php
session_start();
include 'includes/auth.php';
include 'includes/db.php';
// Show message if set
$message = '';
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    unset($_SESSION['message']);
}
// Fetch dashboard counts
$total = mysqli_fetch_assoc(mysqli_query($conn, "SELECT MAX(member_number) AS count FROM members"))['count'];


$active = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) AS count FROM members WHERE payment_status='OK'"))['count'];
$expired = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) AS count FROM members WHERE expiry_date < CURDATE()"))['count'];
$expiring = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) AS count FROM members WHERE expiry_date BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 7 DAY)"))['count'];
$warnings = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(DISTINCT member_id) AS count FROM warnings"))['count'];

$visitors_today = mysqli_fetch_assoc(mysqli_query($conn, "
    SELECT COUNT(*) AS count 
    FROM current_logins 
    WHERE DATE(scan_time) = CURDATE()
"))['count'];


include 'includes/header.php';
?>

<h1 class="mb-4"><i class="fas fa-tachometer-alt"></i> Dashboard<div class="text-start mt-4">
    <?php if (!empty($message)): ?>
  <div class="alert alert-success alert-dismissible fade show" role="alert">
    <?php echo $message; ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
  </div>
<?php endif; ?>

  <form action="update_statuses.php" method="post">
    <button type="submit" class="btn btn-outline-danger">
      <i class="fas fa-sync-alt"></i> Run Membership Status Update
    </button>
  </form>
</div></h1>
<?php if (isset($_SESSION['visitor_added'])): ?>
  <div class="alert alert-success alert-dismissible fade show" role="alert">
    Visitor added successfully!
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
  </div>
  <?php unset($_SESSION['visitor_added']); ?>
<?php endif; ?>
<!-- Manual Expiry Update Button -->

<div class="row g-4">
  <div class="col-md-4 col-sm-6">
    <div class="card text-white bg-primary shadow-sm">
      <div class="card-body d-flex align-items-center">
        <i class="fas fa-users fa-2x me-3"></i>
        <div>
          <h6>Total Members</h6>
          <h4><?= $total ?></h4>
        </div>
      </div>
      <a href="members_all.php" class="card-footer text-white text-center small">View All</a>
    </div>
  </div>

  <div class="col-md-4 col-sm-6">
    <div class="card text-white bg-success shadow-sm">
      <div class="card-body d-flex align-items-center">
        <i class="fas fa-user-check fa-2x me-3"></i>
        <div>
          <h6>Active Members</h6>
          <h4><?= $active ?></h4>
        </div>
      </div>
      <a href="members_active.php" class="card-footer text-white text-center small">View Active</a>
    </div>
  </div>

  <div class="col-md-4 col-sm-6">
    <div class="card text-white bg-danger shadow-sm">
      <div class="card-body d-flex align-items-center">
        <i class="fas fa-user-times fa-2x me-3"></i>
        <div>
          <h6>Expired Members</h6>
          <h4><?= $expired ?></h4>
        </div>
      </div>
      <a href="members_expired.php" class="card-footer text-white text-center small">View Expired</a>
    </div>
  </div>

  <div class="col-md-4 col-sm-6">
    <div class="card text-dark bg-warning shadow-sm">
      <div class="card-body d-flex align-items-center">
        <i class="fas fa-user-clock fa-2x me-3"></i>
        <div>
          <h6>Expiring Soon (7 Days)</h6>
          <h4><?= $expiring ?></h4>
        </div>
      </div>
      <a href="members_expiring.php" class="card-footer text-dark text-center small">View Expiring</a>
    </div>
  </div>

  <div class="col-md-4 col-sm-6">
    <div class="card text-white bg-dark shadow-sm">
      <div class="card-body d-flex align-items-center">
        <i class="fas fa-exclamation-triangle fa-2x me-3"></i>
        <div>
          <h6>Members with Warnings</h6>

          <h4><?= $warnings ?></h4>
        </div>
      </div>
      <a href="warnings.php" class="card-footer text-white text-center small">View Warnings</a>
    </div>
  </div>

  <div class="col-md-4 col-sm-6">
    <div class="card text-white bg-secondary shadow-sm">
      <div class="card-body d-flex align-items-center">
        <i class="fas fa-user-tag fa-2x me-3"></i>
        <div>
          <h6>Members Today</h6>
          <h4><?= $visitors_today ?></h4>
        </div>
      </div>
      <a href="attendance.php" class="card-footer text-white text-center small">View Attendance</a>
    </div>
  </div>
</div>

<!-- Visitor Log Button 
<button class="btn btn-secondary rounded-circle" title="Log Visitor" style="position: fixed; bottom: 85px; right: 20px; z-index: 1050; width: 50px; height: 50px;" data-bs-toggle="modal" data-bs-target="#visitorModal">
  <i class="fas fa-user-tag"></i>
</button>
-->

<!-- Floating Scan Button -->
<button class="scan-btn btn btn-primary rounded-circle" data-bs-toggle="modal" data-bs-target="#scanModal" title="Scan Member" style="position: fixed; bottom: 20px; right: 20px; z-index: 1050;">
  <i class="fas fa-id-card fa-lg"></i>
</button>

<!-- Visitor Modal -->
<div class="modal fade" id="visitorModal" tabindex="-1" aria-labelledby="visitorModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" action="add_visitor.php" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Log a Visitor</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label>Name</label>
          <input type="text" name="name" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>Company / Reason for Visit</label>
          <input type="text" name="reason" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>Time In</label>
          <input type="time" name="time_in" class="form-control" value="<?= date('H:i') ?>">
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-success">Log Visitor</button>
      </div>
    </form>
  </div>
</div>

<?php include 'includes/footer.php'; ?>
